/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.world.chunk;

import net.jayjay.dangerzone.block.Block;
import net.jayjay.dangerzone.block.Blocks;
import net.jayjay.dangerzone.world.World;

public class ChunkCache {
    private final World world;

    public ChunkCache(World world, int x0, int y0, int z0, int x1, int y1, int z1) {
        this.world = world;
    }

    public int getBlock(int x, int y, int z) {
        return this.world.getBlock(x, y, z);
    }

    public Block getBlockObject(int x, int y, int z) {
        int blockId = this.getBlock(x, y, z);
        return Blocks.getBlockById(blockId);
    }

    public boolean isSolidBlock(int x, int y, int z) {
        Block block = this.getBlockObject(x, y, z);
        return block != null && block.isSolid();
    }

    public boolean isLit(int x, int y, int z) {
        return this.world.isLit(x, y, z);
    }

    public boolean blocksLight(int x, int y, int z) {
        Block block = this.getBlockObject(x, y, z);
        return block != null && block.blocksLight();
    }

    public World getWorld() {
        return this.world;
    }
}

